function fault_slip_plot_diag_eigen_coupled(a,A,colors,delta,delta_c,E_hat,mu_dyn,mu_st,NN,...
    sigma_j,T,U,ww,y_plot_max,y_plot_min,y_j,y_tilde,z_j)
%
% Plots diagnostics to check slip-weakening friction computation for coupled eigenvalue
% analysis.  
%

% Retrieve colors:
blue = colors(1,:);

% Compute friction: 
mu_help = mu_st - (mu_st-mu_dyn)*(abs(delta)/delta_c);
mu = min(max(mu_help,mu_dyn),mu_st);

% Plot various quantities:
figure
subplot(1,4,1)
x_plot_min = min(sigma_j/1e6);
x_plot_max = max(sigma_j/1e6);
hold on
line([x_plot_min x_plot_max],[0 0],'LineStyle','-','Color','k','LineWidth',0.5)
line([x_plot_min x_plot_max],[-a -a],'LineStyle',':','Color','k','LineWidth',1)
line([x_plot_min x_plot_max],[a a],'LineStyle',':','Color','k','LineWidth',1)
line([x_plot_min x_plot_max],[y_tilde(1) y_tilde(1)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(2) y_tilde(2)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(3) y_tilde(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(4) y_tilde(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
plot(sigma_j/1e6,y_j,'o','LineWidth',1.5,'Color','r','MarkerSize',3,'MarkerEdgeColor',...
    'red','MarkerFaceColor','white')
% plot(sigma_norm_eff_comb/1e6,y_top,':c','LineWidth',1.5)
hold off
axis([x_plot_min x_plot_max y_plot_min y_plot_max])
box on
xlabel('$\hat\sigma_{\perp}\prime$ (MPa)','Interpreter','latex','FontSize',11)
ylabel('$\it y$ (m)','Interpreter','latex','FontSize',11)

subplot(1,4,2)
x_plot_min = min(delta/1e-3);
x_plot_max = max(delta/1e-3);
hold on
line([x_plot_min x_plot_max],[0 0],'LineStyle','-','Color','k','LineWidth',0.5)
line([x_plot_min x_plot_max],[-a -a],'LineStyle',':','Color','k','LineWidth',1)
line([x_plot_min x_plot_max],[a a],'LineStyle',':','Color','k','LineWidth',1)
line([x_plot_min x_plot_max],[y_tilde(1) y_tilde(1)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(2) y_tilde(2)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(3) y_tilde(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(4) y_tilde(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
plot(delta/1e-3,y_j,'-r','LineWidth',1.5)
hold off
axis([x_plot_min x_plot_max y_plot_min y_plot_max])
box on
xlabel('$\delta$ (mm)','Interpreter','latex','FontSize',11)
ylabel('$\it y$ (m)','Interpreter','latex','FontSize',11)

subplot(1,4,3)
x_plot_min = 0.15;
% % % x_plot_min = 0.45;
x_plot_max = 0.55;
hold on
line([x_plot_min x_plot_max],[0 0],'LineStyle','-','Color','k','LineWidth',0.5)
line([x_plot_min x_plot_max],[-a -a],'LineStyle',':','Color','k','LineWidth',1)
line([x_plot_min x_plot_max],[a a],'LineStyle',':','Color','k','LineWidth',1)
line([x_plot_min x_plot_max],[y_tilde(1) y_tilde(1)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(2) y_tilde(2)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(3) y_tilde(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(4) y_tilde(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([mu_dyn, mu_dyn],[y_plot_min y_plot_max],'LineStyle','--','Color','k','LineWidth',0.5)
line([mu_st, mu_st],[y_plot_min y_plot_max],'LineStyle','--','Color','k','LineWidth',0.5)
plot(mu,y_j,'-r','LineWidth',1.5)
hold off
axis([x_plot_min x_plot_max y_plot_min y_plot_max])
box on
xlabel('$\rm \mu$ (-)','Interpreter','latex','FontSize',11)
ylabel('$\it y$ (m)','Interpreter','latex','FontSize',11)

subplot(1,4,4)
x_plot_min = min(ww);
x_plot_max = max(ww);
hold on
line([x_plot_min x_plot_max],[0 0],'LineStyle','-','Color','k','LineWidth',0.5)
line([x_plot_min x_plot_max],[-a -a],'LineStyle',':','Color','k','LineWidth',1)
line([x_plot_min x_plot_max],[a a],'LineStyle',':','Color','k','LineWidth',1)
line([x_plot_min x_plot_max],[y_tilde(1) y_tilde(1)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(2) y_tilde(2)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(3) y_tilde(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(4) y_tilde(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
plot(ww,y_j,'-r','LineWidth',1.5)
hold off
axis([x_plot_min x_plot_max y_plot_min y_plot_max])
box on
xlabel('$\it w$ (1/m)','Interpreter','latex','FontSize',11)
ylabel('$\it y$ (m)','Interpreter','latex','FontSize',11)

fprintf('Minimum friction value reached = %5.2f. \r\r', min(mu));          

% Plot induced stress rate and slip rate:
sigma_breve = -pi*A*U*E_hat; % induced stress rate Pa/Pa
zz = sqrt(1-z_j.^2); % 1 x N vector
zz_inv = 1./sqrt(1-z_j.^2); % 1 x N vector
Z = diag(zz); % N x N diagonal matrix
Z_inv = diag(zz_inv); % N x N diagonal matrix
E_hat(1,1) = E_hat(1,1)/2;  
d_delta_dp = Z*U*NN*E_hat; % induced slip rate, m/Pa
d2delta_dy_dp = Z_inv*T*E_hat; % induced slip gradient rate, 1/Pa
figure
subplot(1,3,1)
x_plot_min = min(sigma_breve/1e6);
x_plot_max = max(sigma_breve/1e6);
hold on
line([x_plot_min x_plot_max],[0 0],'LineStyle','-','Color','k','LineWidth',0.5)
line([0 0],[y_plot_min y_plot_max],'LineStyle','-','Color','k','LineWidth',0.5)
line([x_plot_min x_plot_max],[-a -a],'LineStyle',':','Color','k','LineWidth',1)
line([x_plot_min x_plot_max],[a a],'LineStyle',':','Color','k','LineWidth',1)
line([x_plot_min x_plot_max],[y_tilde(1) y_tilde(1)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(2) y_tilde(2)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(3) y_tilde(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(4) y_tilde(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
plot(sigma_breve/1e6,y_j,'-r','LineWidth',1.5)
hold off
axis([x_plot_min x_plot_max y_plot_min y_plot_max])
box on
xlabel('$\dot{\breve\sigma}_{\parallel}$ (MPa/Pa)','Interpreter','latex','FontSize',11)
ylabel('$\it y$ (m)','Interpreter','latex','FontSize',11)

subplot(1,3,2)
x_plot_min = min(d2delta_dy_dp*1e3);
x_plot_max = max(d2delta_dy_dp*1e3);
hold on
line([x_plot_min x_plot_max],[0 0],'LineStyle','-','Color','k','LineWidth',0.5)
line([0 0],[y_plot_min y_plot_max],'LineStyle','-','Color','k','LineWidth',0.5)
line([x_plot_min x_plot_max],[-a -a],'LineStyle',':','Color','k','LineWidth',1)
line([x_plot_min x_plot_max],[a a],'LineStyle',':','Color','k','LineWidth',1)
line([x_plot_min x_plot_max],[y_tilde(1) y_tilde(1)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(2) y_tilde(2)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(3) y_tilde(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(4) y_tilde(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
plot(d2delta_dy_dp*1e3,y_j,'-r','LineWidth',1.5)
hold off
axis([x_plot_min x_plot_max y_plot_min y_plot_max])
box on
xlabel('$\dot\delta\prime$ (1/Pa)','Interpreter','latex','FontSize',11)
ylabel('$\it y$ (m)','Interpreter','latex','FontSize',11)

subplot(1,3,3)
x_plot_min = min(d_delta_dp*1e3);
x_plot_max = max(d_delta_dp*1e3);
hold on
line([x_plot_min x_plot_max],[0 0],'LineStyle','-','Color','k','LineWidth',0.5)
line([0 0],[y_plot_min y_plot_max],'LineStyle','-','Color','k','LineWidth',0.5)
line([x_plot_min x_plot_max],[-a -a],'LineStyle',':','Color','k','LineWidth',1)
line([x_plot_min x_plot_max],[a a],'LineStyle',':','Color','k','LineWidth',1)
line([x_plot_min x_plot_max],[y_tilde(1) y_tilde(1)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(2) y_tilde(2)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(3) y_tilde(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_plot_min x_plot_max],[y_tilde(4) y_tilde(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
plot(d_delta_dp*1e3,y_j,'-r','LineWidth',1.5)
hold off
axis([x_plot_min x_plot_max y_plot_min y_plot_max])
box on
xlabel('$\dot\delta$ (mm/Pa)','Interpreter','latex','FontSize',11)
ylabel('$\it y$ (m)','Interpreter','latex','FontSize',11)

